import "@/style/_index.scss";
import "react-international-phone/style.css";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import dynamic from "next/dynamic";
import { ModalProvider } from "@/context/ModalContext";
import { CountryProvider } from "@/context/CountryContext";
import { GoogleAnalytics, GoogleTagManager } from "@next/third-parties/google";
import { Lato, Ubuntu } from "next/font/google";
import { headers } from "next/headers";
import { HomeData } from "@/data/data";
import NextTopLoader from "nextjs-toploader";
const Cta = dynamic(() => import("@/components/layout/Cta"));
const WhatsappBtn = dynamic(() => import("@/components/layout/WhatsappBtn"));
const Header = dynamic(() => import("@/components/layout/Header"));
const lato = Lato({
  subsets: ["latin"],
  weight: ["100", "300", "400", "700", "900"],
  display: "swap",
  variable: "--font_montserrat",
});
const ubuntu = Ubuntu({
  subsets: ["latin"],
  weight: ["300", "400", "700"],
  display: "swap",
  variable: "--font_roboto",
});
export async function generateMetadata() {
  const data = HomeData;
  const { info } = data;
  const {
    search_console_code,
    bing,
    yandex,
    meta_index,
    community_name,
    cover_iamge,
  } = info;
  return {
    robots: {
      index: meta_index,
      follow: meta_index,
    },
    openGraph: {
      type: "website",
      siteName: community_name,
      images: {
        url: cover_iamge,
        width: 100,
        height: 100,
      },
    },
    verification: {
      google: search_console_code,
      yandex: yandex,
      other: {
        "msvalidate.01": [bing],
      },
    },
  };
}
export default async function RootLayout({ children }) {
  const currentYear = new Date().getFullYear();
  const requestHeaders = headers();
  const domain = requestHeaders.get("host") || "";
  const data = HomeData;
  const { info, blog_value } = data;
  const { google_analytics_id, community_name, google_tag_manager_id } = info;
  return (
    <html lang="en">
      <body className={`${lato.variable} ${ubuntu.variable}`}>
        <NextTopLoader
          color="white"
          initialPosition={0.08}
          height={2}
          crawl={true}
          showSpinner={false}
          easing="ease"
          speed={200}
          shadow="0 0 10px white,0 0 5px white"
          template='<div class="bar" role="bar"><div class="peg"></div></div> 
  <div class="spinner" role="spinner"><div class="spinner-icon"></div></div>'
          zIndex={1600}
          showAtBottom={false}
        />
        {google_analytics_id ? (
          <GoogleAnalytics gaId={google_analytics_id} />
        ) : (
          ""
        )}
        {google_tag_manager_id ? (
          <GoogleTagManager gtmId={google_tag_manager_id} />
        ) : (
          ""
        )}

        <CountryProvider>
          <ModalProvider>
            <Header info={info} domain={domain} blog_value={blog_value} />
            {children}
            <div className="container-fluid footer">
              <div className="w-100 d-flex justify-content-center align-items-center p-3 fs-6">
                <a href="/" className="text-white">
                  &copy; {domain} {currentYear}
                </a>
              </div>
            </div>
            <Cta community_name={community_name} domain={domain} />
          </ModalProvider>
        </CountryProvider>
        <WhatsappBtn community_name={community_name} domain={domain} />
      </body>
    </html>
  );
}
