import { domain } from "@/domain/domain";
import dynamic from "next/dynamic";
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const FarazForm = dynamic(() => import("@/sections/FarazForm"));
const Brochure = dynamic(() => import("@/sections/Brochure"));
export const metadata = {
  metadataBase: new URL(`https://${domain}`),
  title: "Privacy Policy | Trusted Real Estate Services",
  description:
    "We prioritize your privacy. Our Privacy Policy explains how we collect, use, and safeguard your information while you search for your dream home",
  keywords: [""],
  alternates: {
    canonical: "/privacy-policy",
  },
  openGraph: {
    type: "website",
    url: "/privacy-policy",
  },
};
export default function PrivacyPolicyPage() {
  return (
    <>
      <WebsiteSchema
        title="Privacy Policy | Trusted Real Estate Services"
        description="We prioritize your privacy. Our Privacy Policy explains how we collect, use, and safeguard your information while you search for your dream home"
        keywords=""
        fullUrl={`https://${domain}/privacy-policy`}
      />
      <RatingSchema title="Privacy Policy | Trusted Real Estate Services" />
      <section>
        <div className="privacy-policy-container container">
          <h1 className="privacy-policy-title">Privacy Policy</h1>
          <p>
            We are dedicated to protecting your privacy. When you use our buying
            and selling of properties services, we will collect, use, disclose,
            and handle your information as described in this Privacy Policy.
          </p>

          <h2>Information Collection</h2>
          <p>
            <strong>What information do we need from you:</strong>
          </p>
          <ul>
            <li>Login into our website and mobile application</li>
            <li>Get the details about services</li>
            <li>Interact with us via social media or other channels</li>
            <li>Speak with workers by phone, email, or in person</li>
          </ul>

          <p>
            <strong>
              The data we gather could consist of but is not restricted to:
            </strong>
          </p>
          <ul>
            <li>Name, address, email, and phone number</li>
            <li>Property preferences and requirements</li>
            <li>Financial information for property transactions</li>
          </ul>

          <h2>Use of Information</h2>
          <p>
            <strong>
              The following are the uses of the information we gather:
            </strong>
          </p>
          <ul>
            <li>To deliver and customize our services</li>
            <li>
              To stay in touch with you about real estate listings, news, and
              pertinent details
            </li>
            <li>
              To expedite real estate transactions and associated services
            </li>
            <li>To enhance our offerings and create new ones</li>
            <li>To fulfill legal requirements</li>
          </ul>

          <h2>Information Sharing</h2>
          <p>
            <strong>We may share your information with:</strong>
          </p>
          <ul>
            <li>
              Responsible outside vendors that help us supply our services
            </li>
            <li>
              Regulatory agencies or legal authorities in compliance with legal
              requirements
            </li>
            <li>
              We do not sell, rent, or trade your personal information to third
              parties for marketing purposes.
            </li>
          </ul>

          <h2>Data Security</h2>
          <p>
            We put in place the proper security measures to guard against
            unauthorized access, alteration, disclosure, and destruction of your
            information.
          </p>

          <h2>Your Choices</h2>
          <ul>
            <li>Access, update, or correct your personal information</li>
            <li>Opt-out of receiving marketing communications</li>
            <li>
              Request the deletion of your personal information, subject to
              legal obligations
            </li>
            <li>Cookies and Tracking Technologies</li>
          </ul>

          <h2>Links to Third-Party Websites</h2>
          <p>
            Links to external websites may be found on our website. The content
            or privacy policies of these websites are not our responsibility. We
            advise you to examine their privacy policies before supplying any
            personal data.
          </p>

          <h2>Children's Privacy</h2>
          <p>
            People under the age of eighteen are not intended recipients of our
            services. We do not intentionally gather personal data from minors.
            Please get in touch with us as a parent or guardian if you think
            your child has given us personal information, and we'll take the
            necessary action to remove it.
          </p>

          <h2>Updating Policy</h2>
          <p>
            This Privacy Policy may be updated from time to time. If there are
            any substantial changes, we will post the updated policy on our
            website to let you know about them.
          </p>

          <h2>Contact Us</h2>
          <p>
            Please get in touch with us if you have any queries, worries, or
            requests about your privacy or our conditions.
          </p>
        </div>
      </section>
      <FarazForm />
      <Brochure />
    </>
  );
}
