import { domain } from "@/domain/domain";
import { FetchData } from "@/libs/api";
// Next.js sitemap.js file in the App Router
export default async function sitemap() {
  // Fetch your dynamic data from an API
  const projects = await FetchData();
  // Create sitemap entries for your dynamic routes
  const postEntries = projects.map((item) => ({
    url: `https://${domain}/projects/${item.slug}`,
    lastModified: new Date(),
    changeFrequency: "weekly",
    priority: 0.7,
  }));
  // Add your static routes
  const staticRoutes = [
    {
      url: `https://${domain}`,
      lastModified: new Date(),
      changeFrequency: "yearly",
      priority: 1,
    },
    {
      url: `https://${domain}/projects`,
      lastModified: new Date(),
      changeFrequency: "yearly",
      priority: 1,
    },
    {
      url: `https://${domain}/about-us`,
      lastModified: new Date(),
      changeFrequency: "yearly",
      priority: 1,
    },
    {
      url: `https://${domain}/privacy-policy`,
      lastModified: new Date(),
      changeFrequency: "yearly",
      priority: 1,
    },
    {
      url: `https://${domain}/contact-us`,
      lastModified: new Date(),
      changeFrequency: "yearly",
      priority: 1,
    },
  ];

  // Combine static and dynamic routes
  return [...staticRoutes, ...postEntries];
}
