export default function BlogSchema({ title, img, url, blogurl }) {
  const Json = {
    "@context": "https://schema.org",
    "@type": "Article",
    headline: title,
    image: img,
    author: {
      "@type": "Person",
      name: "Wilds Community by Aldar",
    },
    publisher: {
      "@type": "Organization",
      name: "Wilds Community by Aldar",
      logo: {
        "@type": "ImageObject",
        url: url,
      },
    },
    mainEntityOfPage: {
      "@type": "WebPage",
      "@id": blogurl,
    },
  };
  return (
    <script
      type="application/ld+json"
      dangerouslySetInnerHTML={{ __html: JSON.stringify(Json) }}
    />
  );
}
