export default function FaqsSchema({ faqs }) {
  const mainEntity = faqs?.map((item) => ({
    "@type": "Question",
    name: item.faq_title,
    acceptedAnswer: {
      "@type": "Answer",
      text: item.faq_description,
    },
  }));
  const Json = {
    "@context": "http://schema.org",
    "@type": "FAQPage",
    mainEntity: mainEntity, // Correct usage
  };
  return (
    <script
      type="application/ld+json"
      dangerouslySetInnerHTML={{ __html: JSON.stringify(Json) }}
    />
  );
}
