import dynamic from "next/dynamic";
import Image from "next/image";
import { FaHome, FaWallet, FaKey, FaArrowCircleRight } from "react-icons/fa";
import { IoBed } from "react-icons/io5";
const FormBtn = dynamic(() => import("@/components/FormBtn"), { ssr: false });
export default function About2({ comuname, img, content }) {
  return (
    <>
      <section>
        <div className="container About2">
          <div className="row">
            <div className="col-lg-6 mt-3">
              <h2 className="mb-3">
                Properties for sale in
                <br /> {comuname}
              </h2>
              <div dangerouslySetInnerHTML={{ __html: content }} />
              <div className="container text-center mt-4 amanites">
                <div className="row">
                  <div className="col-md-3 col-6 mb-2">
                    <IoBed size={30} />
                    <h5>1 - 4</h5>
                    <p>Bedrooms</p>
                  </div>
                  <div className="col-md-3 col-6 mb-2">
                    <FaHome size={30} />
                    <h5>10%</h5>
                    <p>DOWN PAYMENT</p>
                  </div>
                  <div className="col-md-3 col-6 mb-2">
                    <FaWallet size={30} />
                    <h5>AED 2M</h5>
                    <p>STARTING PRICE</p>
                  </div>
                  <div className="col-md-3 col-6 mb-2">
                    <FaKey size={30} />
                    <h5>Q1 2028</h5>
                    <p>HANDOVER</p>
                  </div>
                </div>
              </div>
              <div className="btn-group d-flex gap-2 mt-3">
                <FormBtn
                  className="webbutton d-flex align-items-center gap-2"
                  modaltitle="Get Consultation Now"
                  icon={<FaArrowCircleRight style={{ fontSize: "20px" }} />}
                />
                <FormBtn
                  className="webbutton bg-black d-none d-lg-block d-xl-block"
                  modaltitle="List of exclusive offers"
                />
              </div>
            </div>
            <div className="col-lg-6 d-none d-lg-block d-md-block">
              <Image
                src={img || "/images/overview.png"}
                alt={comuname}
                priority={true}
                width={700}
                height={700}
                className="w-100 object-fit-contain h-100 mb-4"
              />
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
