"use client";
import React, { useState } from "react";
import BCard from "./BCard";
import CategoryList from "../components/CategoryList";
import LatestPosts from "../components/LatestPosts";
function BListing({ data, CardsHeading, category_counts, latest_blog }) {
  // State to manage the number of items to display
  const [visibleCards, setVisibleCards] = useState(5); // Adjust the initial number of visible cards as needed
  // Function to handle loading more items
  const loadMoreCards = () => {
    setVisibleCards((prevVisibleCards) => prevVisibleCards + 5); // Adjust the increment as needed
  };
  return (
    <>
      <section className="mainCards" id="Buy">
        <div className="SaleCards" id="New_Projects">
          <div className="container-fluid">
            <div className="sale-cards-container">
              <div className="container customContainer">
                <div className="row">
                  <div className="col-lg-8 col-md-12">
                    <div className="container">
                      <h2 className="my-2">{CardsHeading}</h2>
                    </div>
                    {/* Display BCard components */}
                    {data.slice(0, visibleCards).map((item, index) => (
                      <BCard
                        key={index}
                        cover_image={item.cover_image}
                        page_title={item.page_title}
                        posted_date={item.posted_date}
                        short_content={item.short_content}
                        slug={item.slug}
                        category={item.category}
                      />
                    ))}
                    {/* Show "Load More" button if there are more items to load */}
                    {visibleCards < data.length && (
                      <div className="text-center mt-4">
                        <button
                          className="btn btn-outline-dark"
                          onClick={loadMoreCards}
                        >
                          Load More
                        </button>
                      </div>
                    )}
                  </div>
                  <div className="col-lg-4 col-md-12">
                    <div className="stickysection">
                      <CategoryList category_counts={category_counts} />
                      <LatestPosts latest_blog={latest_blog} />
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}

export default BListing;
