"use client";
import { useModal } from "@/context/ModalContext";
import React from "react";

export default function ContactUs({ domain }) {
  const { toggleModal } = useModal();
  return (
    <>
      <section className="p-2">
        <div className="container mt-3">
          <div className="text-center">
            <h1 className="mb-2">Contact Us</h1>
            <p>
              Thank you for visiting {domain} . If you have any questions or
              need assistance with buying, selling, or renting real estate,
              we’re here to help! Please feel free to reach out to us via phone,
              email, or by filling out the contact form below. Our team is ready
              to provide you with the support and information you need. We look
              forward to connecting with you soon!
            </p>
            <div className="mt-3">
              <a onClick={() => toggleModal("Contact Us")}>
                <button className="webbutton">Contact Us</button>
              </a>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
