"use client";
import { useModal } from "@/context/ModalContext";
export default function DSP() {
  const { toggleModal } = useModal();
  return (
    <>
      <section className="mt-5">
        <div className="container-fluid">
          <div className="container">
            <div className="row">
              <div className="col-lg-6 d-flex align-items-center">
                <div>
                  <h1 className="mb-3">
                    Properties for sale in Wilds by Aldar
                  </h1>
                  <p>
                    <a href="/buy">Properties for sale in The Wilds </a>
                    Community by Aldar offer a perfect blend of modern luxury
                    and natural tranquility in the heart of Dubailand. Featuring
                    spacious villas and townhouses with contemporary designs,
                    these homes are crafted for comfort and elegance. The
                    community’s prime location ensures easy access to major
                    destinations in Dubai while providing a peaceful retreat
                    surrounded by lush greenery.
                    <br />
                    <br />
                    Developed by Aldar, a trusted name in real estate,
                    <a href="/"> The Wilds Community </a>promises high-quality
                    construction, premium amenities, and excellent investment
                    potential. With competitive pricing and flexible payment
                    plans, these properties are ideal for families and investors
                    looking for a secure and high-value asset in Dubai’s
                    thriving real estate market.
                  </p>
                  <a onClick={() => toggleModal("Get in touch")}>
                    <button className="webbutton mt-3">Get in touch</button>
                  </a>
                </div>
              </div>
              <div className="col-lg-6">
                <img
                  src="/images/img-small.webp"
                  className="conatin w-100 h-100 object-fit-cover mt-3"
                />
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
