"use client";
import dynamic from "next/dynamic";
import Image from "next/image";
const FormBtn = dynamic(() => import("@/components/FormBtn"), {
  ssr: false,
});
import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay, Navigation } from "swiper/modules";
export default function FloorPlan({ community_name, floor_plan }) {
  return (
    <>
      <section className="FloorPlan" id="payment-plan">
        <h2 className="text-center mb-4">Floor Plans of {community_name}</h2>
        <p className="text-center para">{floor_plan?.content}</p>
        <div className="container mt-4 text-center">
          <div className="row">
            <Swiper
              breakpoints={{
                "@0.00": {
                  slidesPerView: 1,
                },
                "@0.75": {
                  slidesPerView: 2,
                },
                "@1.00": {
                  slidesPerView: 3,
                },
                "@1.50": {
                  slidesPerView: 4,
                },
              }}
              slidesPerView={3}
              autoplay={{
                delay: 2500,
                disableOnInteraction: false,
              }}
              pagination={{
                clickable: true,
              }}
              navigation={true}
              modules={[Autoplay, Navigation]}
              className="mySwiper h-100"
            >
              {floor_plan?.bedroom.map((item, i) => (
                <SwiperSlide key={i}>
                  <div className="h-100">
                    <Image
                      src="/images/floor-plan.png"
                      width={300}
                      height={200}
                      className="w-100 h-100"
                    />
                    <h3 className="">{item}</h3>
                  </div>
                </SwiperSlide>
              ))}
            </Swiper>
          </div>
          <FormBtn
            className="webbutton mt-4 mx-auto"
            modaltitle="Download Floor Plan"
          />
        </div>
      </section>
    </>
  );
}
