"use client";
import ImageSlider from "@/components/ImageSlider";
import React, { useState } from "react";
const Gallery = ({ interiorGallery, exteriorGallery, gallery_heading }) => {
  const [view, setView] = useState("interior");
  const galleryToShow = view === "interior" ? interiorGallery : exteriorGallery;
  return (
    <section>
      <div className="gallery-section container p-0" id="gallery">
        <h2 className="text-center mb-4">{gallery_heading}</h2>
        <div className="container">
          <div className="d-flex justify-content-center gap-3 mb-4">
            <button
              className={`${
                view === "interior" ? "webbutton" : "activebutton"
              }`}
              onClick={() => setView("interior")}
            >
              Interior
            </button>
            <button
              className={`${
                view === "exterior" ? "webbutton" : "activebutton"
              }`}
              onClick={() => setView("exterior")}
            >
              Exterior
            </button>
          </div>
          <div className="gallery_imags">
            <ImageSlider images={galleryToShow} />
          </div>
        </div>
      </div>
    </section>
  );
};

export default Gallery;
