import BlogCard from "@/components/BlogCard";
export default async function HBlogSec({ blog }) {
  return (
    <>
      <section className="py-3 py-md-5">
        <div className="container">
          <div className="row justify-content-md-center">
            <div className="col-12 col-md-10 col-lg-8 col-xl-7 col-xxl-6">
              <h2 className="mb-2 display-5 text-center">Our Blogs</h2>
              <hr className="w-50 mx-auto mb-5 mb-xl-9 border-dark-subtle" />
            </div>
          </div>
        </div>
        <div className="container overflow-hidden">
          <div className="row gy-4 gy-xxl-5">
            {blog.map((items, i) => (
              <BlogCard
                title={items.title}
                discription={items.short_content}
                img={items.cover_image}
                date={items.posted_date}
                slug={items.slug}
                key={i}
              />
            ))}
          </div>
        </div>
      </section>
    </>
  );
}
