import Image from "next/image";
const HeroAbout = ({ data, image }) => {
  const { community_name, property_name, developer_name } = data;
  return (
    <section>
      <div className="saria-container container">
        <div className="row">
          <div className="col-md-6">
            <h1>
              {property_name}: Exclusive Waterfront Apartments & Penthouses in a
              luxury 39-floor Residential Complex
            </h1>
            <p>
              {property_name} by {developer_name} is a premier real estate
              development located in the vibrant {community_name}, offering a
              perfect blend of luxury, comfort, and modern living. Designed for
              homeowners and investors alike, this project features a range of
              upscale residences, including stylish apartments, spacious villas,
              and exclusive penthouses, all crafted with high-end finishes and
              smart home technology. Residents can enjoy world-class amenities
              such as infinity pools, state-of-the-art fitness centers,
              landscaped gardens, retail outlets, and 24/7 security.
              Strategically positioned, {property_name} at {community_name}
              provides excellent connectivity to business hubs, shopping malls,
              entertainment venues, and major transportation routes. With high
              ROI potential, flexible payment plans, and freehold ownership,
              this development is an ideal choice for those looking to invest in
              Dubai’s thriving real estate market. Don’t miss the opportunity to
              own a home in {property_name}
              contact us today for more details and availability!
            </p>
          </div>
          <div className="col-md-6">
            <Image
              src={image || ""}
              width={700}
              height={700}
              className="object-fit-cover w-100 h-100 rounded mt-3"
            />
          </div>
          {/* <div className="col-md-6">
            <div className="price-info">
              <div>
                <span>{minimum_price}</span>
                <br />
                <small>PRICES FROM</small>
              </div>
              <div>
                <span>{on_booking}</span>
                <br />
                <small>DOWN PAYMENT</small>
              </div>
              <div>
                <span>{completion}</span>
                <br />
                <small>HANDOVER</small>
              </div>
            </div>
            <div className="d-flex justify-content-center gap-3">
              <button
                className="webbutton"
                onClick={() => toggleModal("Get Availability")}
              >
                <FaCommentAlt /> Get Availability
              </button>
              <button
                className="activebutton"
                onClick={() => toggleModal("Download Brochure")}
              >
                <FaDownload /> Download Brochure
              </button>
            </div>
          </div> */}
        </div>
      </div>
    </section>
  );
};

export default HeroAbout;
