"use client";
import { useModal } from "@/context/ModalContext";
import Image from "next/image";
// import Section from "@/components/Section";
const KeyHighlightsSection = () => {
  const { toggleModal } = useModal();
  const data = [
    {
      key_highlight:
        "Central Park features jogging paths and verdant surroundings.",
    },
    {
      key_highlight:
        "Shopping malls and retail establishments are within walking distance.",
    },
    {
      key_highlight: "Cafes, eateries, and venues for entertainment",
    },
    {
      key_highlight: "communal pools and spaces for kids to play.",
    },
    {
      key_highlight: "fitness facilities and sports courts.",
    },
    {
      key_highlight:
        "High-end finishes include first-rate materials and luxurious interiors.",
    },
  ];
  return (
    <section className="key-highlights">
      <div className="d-flex">
        <span className="dot"></span>
        <hr />
      </div>
      <div className="container">
        <h2 className="highlights-title">KEY HIGHLIGHTS</h2>
        <div className="highlights-content">
          <div className="row">
            <div className="highlights-list col-md-6 col-12">
              <ul>
                {data.map((item, index) => (
                  <li key={index}>{item.key_highlight}</li>
                ))}
              </ul>
              <button
                className="webbutton mt-3"
                onClick={() => toggleModal("Download Free PDF Brochure →")}
              >
                Download Free PDF Brochure →
              </button>
            </div>
            <div className="highlights-image col-md-6 col-12">
              <Image
                src="/images/KeyHighlightsImg.webp"
                width={500}
                height={400}
                alt="Picture of the author"
              />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default KeyHighlightsSection;
