import dynamic from "next/dynamic";
const FormBtn = dynamic(() => import("@/components/FormBtn"), { ssr: false });
const Location = () => {
  const locations = [
    { time: "10-15 Mins", place: "from Dubai Mall" },
    { time: "10-15 Mins", place: "from Burj Khalifa" },
    { time: "10 Mins", place: "from Dubai Marina" },
    { time: "10-15 Mins", place: "from Jumeirah Beach" },
    { time: "15-20 Mins", place: "from The Dubai Frame" },
  ];
  return (
    <section className="location-section">
      <div className="container">
        <h2>Location</h2>
        <p>
          Dubai Maritime City is centrally located and offers easy access to a
          variety of popular attractions in Dubai. Here are some nearby
          attractions with approximate travel times
        </p>

        <div className="location-details">
          {locations.map((loc, index) => (
            <div key={index} className="location-item">
              {loc.time} <span>{loc.place}</span>
            </div>
          ))}
        </div>
        <FormBtn
          className="webbutton bg-white text-black"
          modaltitle="Get More Info"
        />
        <div className="map-container">
          <img src="/images/map.jpg" alt="Location Map" />
        </div>
      </div>
    </section>
  );
};

export default Location;
