"use client";
import OffPlanCard from "@/components/OffPlanCard";
import { useState } from "react";
const OffPlanCardsList = ({
  data,
  heading,
  domain,
  content,
  cardsQuantity,
}) => {
  // // Sale cards Quantity
  const [visibleCards, setVisibleCards] = useState(cardsQuantity); // Initial number of visible cards
  const loadMoreCards = () => {
    setVisibleCards((prevVisibleCards) => prevVisibleCards + cardsQuantity); // Increase by 3 cards
  };
  return (
    <>
      <section className="mainCards" id="Buy">
        <div className="SaleCards" id="New_Projects">
          <div className="container">
            <h1 className="pb-4">{heading}</h1>
            <p className="font-light">{content}</p>
            <div className="sale-cards-container">
              <div className="container mt-5">
                <div className="row">
                  {data?.slice(0, visibleCards).map((property, i) => (
                    <div className="col-md-3 p-0" key={i}>
                      <OffPlanCard
                        domain={domain}
                        property_name={property?.property_name}
                        location={property?.community_name}
                        price={property?.minimum_price}
                        img={property?.cover_image}
                        bedroom={property?.bedrooms}
                        developer={property?.developer_name}
                        types={property?.property_types}
                        size={property?.min_size}
                        usps1={property?.usps?.usps1}
                        usps2={property?.usps?.usps2}
                        slug={property?.slug}
                      />
                    </div>
                  ))}
                </div>
              </div>
              <div className="container mt-4">
                <div className="col-md-12">
                  {visibleCards < data.length && (
                    <div className="text-center">
                      <button className="webbutton" onClick={loadMoreCards}>
                        Load More
                      </button>
                    </div>
                  )}
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default OffPlanCardsList;
