export default function SimpleMap({ lag, lat, property_name }) {
  return (
    <section>
      <div className="container mb-4">
        <div className="map-main-wrapper">
          <div className="Map-heading">
            <h2 className="mb-4 text-center">{property_name} Location</h2>
          </div>
          <div style={{ width: "100%", height: "450px" }}>
            <iframe
              id="map"
              width="100%"
              height="100%"
              style={{ border: 0 }}
              loading="lazy"
              allowfullscreen
              referrerpolicy="no-referrer-when-downgrade"
              src={`https://www.google.com/maps?q=${lag},${lat}&z=17&output=embed`}
            ></iframe>
          </div>
        </div>
      </div>
    </section>
  );
}
