"use client";
import React from "react";
import Image from "next/image";
import { useModal } from "@/context/ModalContext";
export default function StartInvesting({ property_type }) {
  const { toggleModal } = useModal();
  return (
    <>
      <section className="investment-section">
        <div className="container">
          <div className="investment-banner container-fluid">
            <div className="row align-items-center">
              <div className="col-md-5 col-sm-12">
                <h1>
                  Start Investing In
                  <br /> Dubai Today
                </h1>
                <p>
                  {property_type} in Dubai Luxurious Residence offering
                  panoramic city views, high-end amenities, and prime locations,
                  perfect for modern urban living.
                </p>
                <button
                  className="webbutton"
                  onClick={() => toggleModal("Get in Touch")}
                >
                  Learn More
                </button>
              </div>
              <div className="col-md-7 col-sm-12 right-side">
                <Image
                  width={400}
                  height={240}
                  alt={"Start Investing In Dubai Today"}
                  src="/images/investing_img.jpeg"
                  className="logo_img img-fluid"
                />
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
